#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char* pronadji_s(char* s1, char* s2) {
    int i, j, ind;
    i = 0;
    while (s1[i] != '\0') {
        ind = 1;
        j = 0;
        while (s1[i+j] != '\0' && s2[j] != '\0') {
            if (s1[i+j] != s2[j]) {
                ind = 0;
                break;
            }
            j++;
        }
        if (ind == 1) {
            return s1 + i;
        }
        i++;
    }
    return NULL;
}

void to_upper(char* s) {
    int i = 0;
    while (s[i] != '\0') {
        if ('a' <= s[i] && s[i] <= 'z') {
            s[i] = s[i] - 'a' + 'A';
        }
        i++;
    }
}

void to_lower(char* s) {
    int i = 0;
    while (s[i] != '\0') {
        if ('A' <= s[i] && s[i] <= 'Z') {
            s[i] = s[i] - 'A' + 'a';
        }
        i++;
    }
}

/// Cezarovo sifriranje stringova
void sifriraj(char* s, int k) {
    int i = 0;
    while (s[i] != '\0') {
        s[i] = (s[i] - 'a' + k) % 26 + 'a';
        i++;
    }
}
void desifruj(char* s, int k) {
    int i = 0;
    while (s[i] != '\0') {
        // zasto ne moze samo -k?
        s[i] = (s[i] - 'a' + 26 - k) % 26 + 'a';
        i++;
    }
}

/// kompresija stringova
void compress(char* s1, char* s2) {
    int i = 0;
    //int j = 0;
    char pom[10];
    s2[0] = '\0';

    while (s1[i] != '\0') {
        int cnt = 1;
        while (s1[i] == s1[i+1]) {
            cnt++;
            i++;
        }
        sprintf(pom, "%c", s1[i]);
        strcat(s2, pom);

        sprintf(pom, "%d", cnt);
        strcat(s2, pom);

        /*s2[j+1] = '0' + cnt;
        j += 2;*/

        i++;
    }
    //s2[j] = '\0';
}

int main()
{
    char s1[100] = "principi programiranja AB";
    char s2[100] = "prog";

    printf("%p %p %p\n", s1, strstr(s1, s2), pronadji_s(s1, s2));

    char* token = strtok(s1, " ");
    while (token != NULL) {
        printf("%s\n", token);
        token = strtok(NULL, " ");
    }

    char s3[100] = "abc 123";
    char s4[100] = "xyz 456";

    // ne radi
    /*char* token1 = strtok(s3, " ");
    char* token2 = strtok(s4, " ");
    while (token1 != NULL && token2 != NULL) {
        printf("%s %s\n", token1, token2);
        token1 = strtok(NULL, " ");
        token2 = strtok(NULL, " ");
    }*/

    char* pok1;
    char* pok2;

    char* token1 = strtok_r(s3, " ", &pok1);
    char* token2 = strtok_r(s4, " ", &pok2);

    while (token1 != NULL && token2 != NULL) {
        printf("%s %s\n", token1, token2);
        token1 = strtok_r(NULL, " ", &pok1);
        token2 = strtok_r(NULL, " ", &pok2);
    }

    char s5[100] = "abc12xyz#$";
    to_upper(s5);
    printf("%s\n", s5);
    printf("%d %d %d\n", 'a', 'b', 'z');
    printf("%d %d %d\n", 'A', 'B', 'Z');
    printf("%d\n", 'g'-'a'+'A');
    to_lower(s5);
    printf("%s\n", s5);

    char s6[100] = "programiranjewxyz";
    sifriraj(s6, 4);
    printf("%s\n", s6);
    desifruj(s6, 4);
    printf("%s\n", s6);

    char s7[100] = "aaaaaaaaaaxbbbbyccc";
    char s8[100];
    compress(s7, s8);
    puts(s7);
    puts(s8);

    return 0;
}
